--
--
-- ClearCache immer zuerst vor allem, damit evtl im Trigger dann auf aktuelle Werte zugegriffen wird
--
--

-- ABK-Arbeitsgänge (ab2)
  -- INSERT, UPDATE
    CREATE OR REPLACE FUNCTION tcache.clearcache_tplanterm_abk_proz_fertig__ab2__aiu() RETURNS TRIGGER AS $$
      DECLARE r RECORD;
      BEGIN
        FOR r IN SELECT * FROM tplanterm.get_all_parent_abk(new.a2_ab_ix) LOOP
            PERFORM tcache.function_cache_setdirty_1param('tplanterm.abk_proz_fertig', r.get_all_parent_abk);
            PERFORM tcache.function_cache_setdirty_1param('tplanterm.abk_offen_ag', r.get_all_parent_abk);  
        END LOOP;
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_tplanterm_abk_proz_fertig__ab2__aiu ON ab2;
    
    CREATE TRIGGER _50cache__clearcache_tplanterm_abk_proz_fertig__ab2__aiu
      AFTER INSERT OR UPDATE
      OF a2_n, a2_ks, a2_aknr, a2_tr, a2_th, a2_tn, a2_tv, a2_ta, a2_time_stemp, a2_ende --a2_n wegen neuanlage Arbeitsgang
      ON ab2
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_tplanterm_abk_proz_fertig__ab2__aiu();

     CREATE OR REPLACE FUNCTION tcache.clearcache_tplanterm_abk_offen_ag__wkstplan__aiu() RETURNS TRIGGER AS $$
      DECLARE r RECORD;
      BEGIN
        FOR r IN SELECT * FROM ab2, tplanterm.get_all_parent_abk(a2_ab_ix) WHERE a2_id = new.a2w_a2_id LOOP
            PERFORM tcache.function_cache_setdirty_1param('tplanterm.abk_offen_ag', r.get_all_parent_abk);  
        END LOOP;
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_tplanterm_abk_offen_ag__wkstplan__aiu ON ab2_wkstplan;
    
    CREATE TRIGGER _50cache__clearcache_tplanterm_abk_offen_ag__wkstplan__aiu
      AFTER INSERT OR UPDATE
      OF a2w_oks --, a2w_resource_id_main_terminated, a2w_resource_ks_abt_main_terminated --Terminierte KS
      ON ab2_wkstplan
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_tplanterm_abk_offen_ag__wkstplan__aiu();        
    --
  -- DELETE
    CREATE OR REPLACE FUNCTION tcache.clearcache_tplanterm_abk_proz_fertig__ab2__ad() RETURNS TRIGGER AS $$
      DECLARE r RECORD;
      BEGIN
        FOR r IN SELECT * FROM tplanterm.get_all_parent_abk(old.a2_ab_ix) LOOP
            PERFORM tcache.function_cache_setdirty_1param('tplanterm.abk_proz_fertig', r.get_all_parent_abk);
            PERFORM tcache.function_cache_setdirty_1param('tplanterm.abk_offen_ag', r.get_all_parent_abk);  
        END LOOP;
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_tplanterm_abk_proz_fertig__ab2__ad ON ab2;
    
    CREATE TRIGGER _50cache__clearcache_tplanterm_abk_proz_fertig__ab2__ad
      AFTER DELETE
      ON ab2
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_tplanterm_abk_proz_fertig__ab2__ad();
    --
--

-- ABK
  -- UPDATE
    CREATE OR REPLACE FUNCTION tcache.clearcache_tplanterm_abk_proz_fertig__abk__au__menge() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('tplanterm.abk_proz_fertig', new.ab_ix);
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_tplanterm_abk_proz_fertig__abk__au__menge ON abk;
    
    CREATE TRIGGER _50cache__clearcache_tplanterm_abk_proz_fertig__abk__au__menge
      AFTER UPDATE
      OF ab_st_uf1
      ON abk
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_tplanterm_abk_proz_fertig__abk__au__menge();
    --
  -- UPDATE ab_parentabk  
    CREATE OR REPLACE FUNCTION tcache.clearcache_tplanterm_abk_proz_fertig__abk__au__parentabk() RETURNS TRIGGER AS $$
      DECLARE r RECORD;
      BEGIN
        FOR r IN SELECT * FROM tplanterm.get_all_parent_abk(new.ab_parentabk) LOOP
            PERFORM tcache.function_cache_setdirty_1param('tplanterm.abk_proz_fertig', r.get_all_parent_abk);
            PERFORM tcache.function_cache_setdirty_1param('tplanterm.abk_offen_ag', r.get_all_parent_abk);  
        END LOOP;
        FOR r IN SELECT * FROM tplanterm.get_all_parent_abk(old.ab_parentabk) LOOP
            PERFORM tcache.function_cache_setdirty_1param('tplanterm.abk_proz_fertig', r.get_all_parent_abk);
            PERFORM tcache.function_cache_setdirty_1param('tplanterm.abk_offen_ag', r.get_all_parent_abk);  
        END LOOP;
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_tplanterm_abk_proz_fertig__abk__au__parentabk ON abk;
    
    CREATE TRIGGER _50cache__clearcache_tplanterm_abk_proz_fertig__abk__au__parentabk
      AFTER UPDATE
      OF ab_parentabk
      ON abk
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_tplanterm_abk_proz_fertig__abk__au__parentabk();
    --
  -- UPDATE ag_done, ag_stkl
    CREATE OR REPLACE FUNCTION tcache.clearcache_tplanterm_abk_proz_fertig__abk__au__auftgi__done() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('tplanterm.abk_proz_fertig', new.ag_parentabk);
        PERFORM tcache.function_cache_setdirty_1param('tplanterm.abk_offen_ag', new.ag_parentabk);
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    CREATE TRIGGER _50cache__clearcache_tplanterm_abk_proz_fertig__abk__au__auftgi__done
      AFTER UPDATE
      OF ag_done, ag_stkl
      ON auftg
      FOR EACH ROW
      WHEN  ( -- Wenn ich eine eigene ABK habe, aktualisiert die ABK nach oben durch.
                  new.ag_ownabk IS NULL
              -- Ich muss eine Materialposition einer ABK sein.
              AND new.ag_parentabk IS NOT NULL
            )
      EXECUTE PROCEDURE tcache.clearcache_tplanterm_abk_proz_fertig__abk__au__auftgi__done();
    --
--

-- Auftrag: auftg_pos_wert_calc, sum_auftg_dokunr
 -- Beachte Trigger AuftgAbzu
  -- function_cache_setcache_auftg_pos_wert_calc
    CREATE OR REPLACE FUNCTION tcache.function_cache_setcache_auftg_pos_wert_calc(agid INTEGER, offen BOOL, basis_w BOOL, withtotalpos BOOL, forceOptionalposWert BOOL, forceStornoPosWert BOOL, result NUMERIC) RETURNS VOID AS $$
      BEGIN
        PERFORM tcache.function_cache_setcache('auftg_pos_wert_calc', agid::VARCHAR, offen::VARCHAR, basis_w::VARCHAR, withtotalpos::VARCHAR, forceOptionalposWert::VARCHAR, forceStornoPosWert::VARCHAR, NULL, result);
        RETURN;
      END $$ LANGUAGE plpgsql;
    --
  -- INSERT / UPDATE

    CREATE OR REPLACE FUNCTION tcache.clearcache_auftg_pos_wert_calc__auftg__aiu__werte() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('auftg_pos_wert_calc', new.ag_id);
       RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_auftg_pos_wert_calc__auftg__aiu__werte ON auftg;
    
    CREATE TRIGGER _50cache__clearcache_auftg_pos_wert_calc__auftg__aiu__werte
      AFTER INSERT OR UPDATE
      OF ag_stk, ag_stkl, ag_preis, ag_preiseinheit, ag_vkp, ag_kurs, ag_ustpr, ag_canrabatt, ag_arab, ag_vkptotalpos, ag_done, ag_storno, ag_nstatistik, ag_dokunr 
      ON auftg
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_auftg_pos_wert_calc__auftg__aiu__werte();
    --
  -- DELETE
    CREATE OR REPLACE FUNCTION tcache.clearcache_auftg_pos_wert_calc__auftg__ad() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('auftg_pos_wert_calc', old.ag_id);
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_auftg_pos_wert_calc__auftg__ad ON auftg;
    
    CREATE TRIGGER _50cache__clearcache_auftg_pos_wert_calc__auftg__ad
      AFTER DELETE
      ON auftg
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_auftg_pos_wert_calc__auftg__ad();
    --
--

-- Auftrags-Dokument (auftgdokutxt)
  -- INSERT, UPDATE
    CREATE OR REPLACE FUNCTION tcache.clearcache_auftg_pos_wert_calc__auftgdokutxt__aiu__gesrab() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('auftg_pos_wert_calc', ag_id) FROM auftgdokutxt JOIN auftg ON ag_dokunr=atd_dokunr WHERE atd_dokunr=new.atd_dokunr;
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_auftg_pos_wert_calc__auftgdokutxt__gesrab ON auftgdokutxt;
    
    CREATE TRIGGER _50cache__clearcache_auftg_pos_wert_calc__auftgdokutxt__gesrab
      AFTER INSERT OR UPDATE
      OF atd_gesrab
      ON auftgdokutxt
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_auftg_pos_wert_calc__auftgdokutxt__aiu__gesrab();
    --
  -- DELETE
    CREATE OR REPLACE FUNCTION tcache.clearcache_auftg_pos_wert_calc__auftgdokutxt__ad() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('auftg_pos_wert_calc', ag_id) FROM auftgdokutxt JOIN auftg ON ag_dokunr=atd_dokunr WHERE ag_dokunr=old.atd_dokunr;
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_auftg_pos_wert_calc__auftgdokutxt__ad ON auftgdokutxt;
    
    CREATE TRIGGER _50cache__clearcache_auftg_pos_wert_calc__auftgdokutxt__ad
      AFTER DELETE
      ON auftgdokutxt
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_auftg_pos_wert_calc__auftgdokutxt__ad();
    --
--

-- Beleg_P: beleg_p__pos_wert_calc
 -- Beachte Trigger abzu_p
  -- function_cache_setcache_auftg_pos_wert_calc
    CREATE OR REPLACE FUNCTION tcache.function_cache_setcache_beleg_p__pos_wert_calc(pid INTEGER, offen BOOL, basis_w BOOL, withtotalpos BOOL, forceOptionalposWert BOOL, forceStornoPosWert BOOL, result NUMERIC) RETURNS VOID AS $$
      BEGIN
        PERFORM tcache.function_cache_setcache('beleg_p__pos_wert_calc', pid::VARCHAR, offen::VARCHAR, basis_w::VARCHAR, withtotalpos::VARCHAR, forceOptionalposWert::VARCHAR, forceStornoPosWert::VARCHAR, NULL, result);
        RETURN;
      END $$ language plpgsql;
    --
  -- INSERT / UPDATE
    /* direkt in Funktionen?
    CREATE OR REPLACE FUNCTION tcache.clearcache_beleg_p__pos_wert_calc__beleg_p__aiu__werte() RETURNS TRIGGER AS $$
      BEGIN
       PERFORM tcache.function_cache_setdirty_1param('beleg_p__pos_wert_calc', new.p_id);
       RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_beleg_p__pos_wert_calc__auftg__aiu__werte ON auftg;
    
    CREATE TRIGGER _50cache__clearcache_beleg_p_pos__wert_calc__auftg__aiu__werte
      AFTER INSERT OR UPDATE
      OF ag_stk, ag_stkl, ag_preis, ag_preiseinheit, ag_vkp, ag_kurs, ag_ustpr, ag_canrabatt, ag_arab, ag_vkptotalpos, ag_done, ag_storno, ag_nstatistik, ag_dokunr 
      ON TWawi.beleg_p
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_beleg_p__pos_wert_calc__beleg_p__aiu__werte();
    --
  -- DELETE
    CREATE OR REPLACE FUNCTION tcache.clearcache_beleg_p_pos_wert_calc__auftg__ad() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('beleg_p__pos_wert_calc', old.p_id);
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_beleg_p_pos_wert_calc__auftg__ad ON auftg;
    
    CREATE TRIGGER _50cache__clearcache_beleg_p_pos_wert_calc__auftg__ad
      AFTER DELETE
      ON TWawi.beleg_p
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_beleg_p_pos_wert_calc__beleg_p__ad();
    --
    */
--


-- Lieferschein (belegpos, belegdokument, belp_belegtyp/beld_belegtyp='LFS')
-- Lieferschein anlegen/löschen/Definitiv setzen/Nicht verrechenbar setzen/Lagerabgangsdatum setzen
  -- Lieferscheinpositionen (belegpos, belp_belegtyp='LFS')
    -- INSERT, UPDATE
      CREATE OR REPLACE FUNCTION tcache.clearcache_auftg__lief_rech_data__belegposlifsch__aiu__belpagid() RETURNS TRIGGER AS $$
        BEGIN
          IF tg_op='UPDATE' THEN
              PERFORM tcache.function_cache_setdirty_1param('auftg__lief_rech_data', old.belp_ag_id);
          END IF;
          PERFORM tcache.function_cache_setdirty_1param('auftg__lief_rech_data', new.belp_ag_id);
          RETURN null;
        END $$ LANGUAGE plpgsql;
      
      DROP TRIGGER IF EXISTS _50cache__clearcache_auftg__lief_rech_data__belegposlifsch__aiu_belpagid ON belegpos;
      
      CREATE TRIGGER _50cache__clearcache_auftg__lief_rech_data__belegposlifsch__aiu_belpagid
        AFTER INSERT OR UPDATE
        OF belp_ag_id, belp_termin, belp_erledigt, belp_storniert
        ON belegpos
        FOR EACH ROW
        WHEN (new.belp_belegtyp='LFS')
        EXECUTE PROCEDURE tcache.clearcache_auftg__lief_rech_data__belegposlifsch__aiu__belpagid();
      --
    -- DELETE
      CREATE OR REPLACE FUNCTION tcache.clearcache_auftg__lief_rech_data__belegposlifsch__ad__belpagid() RETURNS TRIGGER AS $$
        BEGIN
          PERFORM tcache.function_cache_setdirty_1param('auftg__lief_rech_data', old.belp_ag_id);
          RETURN null;
        END $$ LANGUAGE plpgsql;
      
      DROP TRIGGER IF EXISTS _50cache__clearcache_auftg__lief_rech_data__belegposlifsch__ad__belpagid ON belegpos;
      
      CREATE TRIGGER _50cache__clearcache_auftg__lief_rech_data__belegposlifsch__ad__belpagid
        AFTER DELETE
        ON belegpos
        FOR EACH ROW
        WHEN ((old.belp_belegtyp='LFS') AND (old.belp_ag_id IS NOT NULL))
        EXECUTE PROCEDURE tcache.clearcache_auftg__lief_rech_data__belegposlifsch__ad__belpagid();
      --
  -- Lieferschein-Kopf (belegdokument, beld_belegtyp='LFS')
    -- UPDATE
      CREATE OR REPLACE FUNCTION tcache.clearcache_auftg__lief_rech_data__belegdokumentlifsch__au() RETURNS TRIGGER AS $$
        BEGIN
          IF tg_op='UPDATE' THEN
              PERFORM tcache.function_cache_setdirty_1param('auftg__lief_rech_data', belp_ag_id) FROM lieferschein_pos WHERE belp_dokument_id = old.beld_id;
          END IF;
          PERFORM tcache.function_cache_setdirty_1param('auftg__lief_rech_data', belp_ag_id) FROM lieferschein_pos WHERE belp_dokument_id = new.beld_id;
          RETURN null;
        END $$ LANGUAGE plpgsql;
      
      DROP TRIGGER IF EXISTS _50cache__clearcache_auftg__lief_rech_data__belegdokumentlifsch__au ON belegdokument;
      
      CREATE TRIGGER _50cache__clearcache_auftg__lief_rech_data__belegdokumentlifsch__au
        AFTER UPDATE
        OF beld_definitiv
        ON belegdokument
        FOR EACH ROW
        WHEN (new.beld_belegtyp='LFS')
        EXECUTE PROCEDURE tcache.clearcache_auftg__lief_rech_data__belegdokumentlifsch__au();
      --
    -- DELETE-Trigger brauchen wir nicht, weil die Lieferscheinpositionen das setDirty erledigen.
--

-- Ldsdok: auftg_pos_wert_calc, sum_auftg_dokunr
 -- Beachte Trigger LdsdokAbzu
  -- function_cache_setcache_ldsdok_pos_wert_calc
    CREATE OR REPLACE FUNCTION tcache.function_cache_setcache_ldsdok_pos_wert_calc(ldid INTEGER, offen BOOL, basis_w BOOL, result NUMERIC) RETURNS VOID AS $$
      BEGIN
        PERFORM tcache.function_cache_setcache('ldsdok_pos_wert_calc', ldid::VARCHAR, offen::VARCHAR, basis_w::VARCHAR, NULL, NULL, NULL, NULL, result);
        RETURN;
      END $$ language plpgsql;
    --
  -- UPDATE
    CREATE OR REPLACE FUNCTION tcache.clearcache_ldsdok_pos_wert_calc__ldsdok__au__werte() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('ldsdok_pos_wert_calc', new.ld_id);
        --PERFORM tcache.function_cache_setdirty_1param('sum_ldsdok_dokunr', old.ld_dokunr);
        --PERFORM tcache.function_cache_setdirty_1param('sum_ldsdok_dokunr', new.ld_dokunr);
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_ldsdok_pos_wert_calc__ldsdok__au__werte ON ldsdok;
    
    CREATE TRIGGER _50cache__clearcache_ldsdok_pos_wert_calc__ldsdok__au__werte
      AFTER UPDATE
      OF ld_stk, ld_stkl, ld_ep, ld_kurs, ld_arab, ld_done, ld_storno, /*ld_dokunr, ACHTUNG dann auch bei INSERT!*/ ld_steuproz, ld_preis, ld_preiseinheit, ld_ekp_mce
      ON ldsdok
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_ldsdok_pos_wert_calc__ldsdok__au__werte();
    --
  -- DELETE
    CREATE OR REPLACE FUNCTION tcache.clearcache_ldsdok_pos_wert_calc__ldsdok__ad() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('ldsdok_pos_wert_calc', old.ld_id);
        
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_ldsdok_pos_wert_calc__ldsdok__ad ON ldsdok;
    
    CREATE TRIGGER _50cache__clearcache_ldsdok_pos_wert_calc__ldsdok__ad
      AFTER DELETE
      ON ldsdok
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_ldsdok_pos_wert_calc__ldsdok__ad();
    --
--

-- Bestell-Dokument (ldsdokdokutxt)
  -- INSERT, UPDATE
    CREATE OR REPLACE FUNCTION tcache.clearcache_ldsdok_pos_wert_calc__ldsdokdokutxt__aiu__gesrab() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('ldsdok_pos_wert_calc', ld_id) FROM ldsdokdokutxt JOIN ldsdok ON ld_dokunr=ltd_dokunr WHERE ltd_dokunr=new.ltd_dokunr;
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_ldsdok_pos_wert_calc__ldsdokdokutxt__gesrab ON ldsdokdokutxt;
    
    CREATE TRIGGER _50cache__clearcache_ldsdok_pos_wert_calc__ldsdokdokutxt__gesrab
      AFTER INSERT OR UPDATE
      OF ltd_gesrab
      ON ldsdokdokutxt
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_ldsdok_pos_wert_calc__ldsdokdokutxt__aiu__gesrab();
    --
  -- DELETE
    CREATE OR REPLACE FUNCTION tcache.clearcache_ldsdok_pos_wert_calc__ldsdokdokutxt__ad() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('ldsdok_pos_wert_calc', ld_id) FROM ldsdokdokutxt JOIN ldsdok ON ld_dokunr=ltd_dokunr WHERE ld_dokunr=old.ltd_dokunr;
        
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_ldsdok_pos_wert_calc__ldsdokdokutxt__ad ON ldsdokdokutxt;
    
    CREATE TRIGGER _50cache__clearcache_ldsdok_pos_wert_calc__ldsdokdokutxt__ad
      AFTER DELETE
      ON ldsdokdokutxt
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_ldsdok_pos_wert_calc__ldsdokdokutxt__ad();
    --
--

-- Belege/Ausgangsrechnungen (belkopf, belzeil_auftg_lif)
  -- Belegzeilen (belzeil_auftg_lif)
    -- INSERT, UPDATE
      CREATE OR REPLACE FUNCTION tcache.clearcache_auftg_pos_wert_calc__belzeil_auftg_lif__aiu__werte() RETURNS TRIGGER AS $$
        BEGIN
          IF tg_op = 'UPDATE' THEN
              PERFORM tcache.function_cache_setdirty_1param('auftg__lief_rech_data', ag_id) FROM auftg WHERE ag_astat = 'E' AND ag_nr = old.bz_auftg AND ag_pos = old.bz_auftgpos; 
          END IF;
          PERFORM tcache.function_cache_setdirty_1param('auftg__lief_rech_data', ag_id) FROM auftg WHERE ag_astat = 'E' AND ag_nr = new.bz_auftg AND ag_pos = new.bz_auftgpos;
          
          -- Die Anzahlungs-/Abschlagsrechnung bzw. Gutschrift auf Anzahlung ändert sich. Alle Schlussrechnungen am zug. Auftrag müssen ihren Abschlags-Wert neu kalkulieren.
          -- Rechungstyp irrelavant: Es sind alle Kombinationen (txba) möglich und Rechnung muss sich selbst zurücksetzen können.
          PERFORM tcache.function_cache_setdirty_1param('bel_abschlagrechbetrag', bz_be_bnr)
          FROM (
              SELECT DISTINCT bz_be_bnr
              FROM belzeil_grund
              WHERE bz_auftg IN (SELECT bz_auftg FROM belzeil_grund WHERE bz_be_bnr = new.bz_be_bnr) -- Alle Schlussrechnungen anhand aller Auftragsbezüge zurücksetzen. Grund: Freie Belegzeilen wirken sich auf alle Schlussrechnungen aus.
              
              UNION
              SELECT new.bz_be_bnr -- Auch Rechnung selbst setzt eigenen Abschlags-Wert zurück, wenn fakturierte Menge sich ändert.
          ) AS dirty_invoices;
          
          RETURN null;
        END $$ LANGUAGE plpgsql;
      
      DROP TRIGGER IF EXISTS _50cache__clearcache_auftg_pos_wert_calc__belzeil_auftg_lif__aiu__werte ON belzeil_auftg_lif;
      
      CREATE TRIGGER _50cache__clearcache_auftg_pos_wert_calc__belzeil_auftg_lif__aiu__werte
        AFTER INSERT OR UPDATE
        OF bz_fakt, bz_vkp, bz_arab, bz_gesrab, bz_auftg, bz_auftgpos, bz_preis, bz_preiseinheit
        ON belzeil_auftg_lif
        FOR EACH ROW
        EXECUTE PROCEDURE tcache.clearcache_auftg_pos_wert_calc__belzeil_auftg_lif__aiu__werte();
      --
      
      -- vererbte Tabelle für freie Belegzeilen
      DROP TRIGGER IF EXISTS _50cache__clearcache_auftg_pos_wert_calc__belzeil_frei__aiu__werte ON belzeil_frei;
      
      CREATE TRIGGER _50cache__clearcache_auftg_pos_wert_calc__belzeil_frei__aiu__werte
        AFTER INSERT OR UPDATE
        OF bz_fakt, bz_vkp, bz_arab, bz_gesrab, bz_auftg, bz_auftgpos, bz_preis, bz_preiseinheit
        ON belzeil_frei
        FOR EACH ROW
        EXECUTE PROCEDURE tcache.clearcache_auftg_pos_wert_calc__belzeil_auftg_lif__aiu__werte();
      --
      
      -- Grund-Tabelle für Aktualisierung aus Abzu
      -- vgl. Trigger belabzu__a_iud, siehe UPDATE belzeil_grund SET bz_id = bz_id
      DROP TRIGGER IF EXISTS _50cache__clearcache_auftg_pos_wert_calc__belzeil_grund__au__werte ON belzeil_grund;
      
      CREATE TRIGGER _50cache__clearcache_auftg_pos_wert_calc__belzeil_grund__au__werte
        AFTER UPDATE
        OF bz_id
        ON belzeil_grund
        FOR EACH ROW
        EXECUTE PROCEDURE tcache.clearcache_auftg_pos_wert_calc__belzeil_auftg_lif__aiu__werte();
      --
    -- DELETE
      CREATE OR REPLACE FUNCTION tcache.clearcache_auftg_pos_wert_calc__belzeil_auftg_lif__ad() RETURNS TRIGGER AS $$
        BEGIN
          PERFORM tcache.function_cache_setdirty_1param('auftg__lief_rech_data', ag_id) FROM belzeil_auftg_lif, auftg WHERE ag_astat = 'E' AND ag_nr = old.bz_auftg AND ag_pos = old.bz_auftgpos;
          
          -- Die Anzahlungs-/Abschlagsrechnung bzw. Gutschrift auf Anzahlung ändert sich. Alle Schlussrechnungen am zug. Auftrag müssen ihren Abschlags-Wert neu kalkulieren.
          -- Rechungstyp irrelavant: Es sind alle Kombinationen (txba) möglich und Rechnung muss sich selbst zurücksetzen können.
          PERFORM tcache.function_cache_setdirty_1param('bel_abschlagrechbetrag', bz_be_bnr)
          FROM (
              SELECT DISTINCT bz_be_bnr
              FROM belzeil_grund
              WHERE bz_auftg IN (SELECT bz_auftg FROM belzeil_grund WHERE bz_be_bnr = old.bz_be_bnr) -- Alle Schlussrechnungen anhand aller Auftragsbezüge zurücksetzen. Grund: Freie Belegzeilen wirken sich auf alle Schlussrechnungen aus.
              
              UNION
              SELECT old.bz_be_bnr -- Auch Rechnung selbst setzt eigenen Abschlags-Wert zurück, wenn ganze Position gelöscht wird (nicht mehr relevant für Abschlag).
          ) AS dirty_invoices;
          
          RETURN null;
        END $$ LANGUAGE plpgsql;
      
      DROP TRIGGER IF EXISTS _50cache__clearcache_auftg_pos_wert_calc__belzeil_auftg_lif__ad ON belzeil_auftg_lif;
      
      CREATE TRIGGER _50cache__clearcache_auftg_pos_wert_calc__belzeil_auftg_lif__ad
        AFTER DELETE
        ON belzeil_auftg_lif
        FOR EACH ROW
        EXECUTE PROCEDURE tcache.clearcache_auftg_pos_wert_calc__belzeil_auftg_lif__ad();
      --
      
      -- vererbte Tabelle für freie Belegzeilen
      DROP TRIGGER IF EXISTS _50cache__clearcache_auftg_pos_wert_calc__belzeil_frei__ad ON belzeil_frei;
      
      CREATE TRIGGER _50cache__clearcache_auftg_pos_wert_calc__belzeil_frei__ad
        AFTER DELETE
        ON belzeil_frei
        FOR EACH ROW
        EXECUTE PROCEDURE tcache.clearcache_auftg_pos_wert_calc__belzeil_auftg_lif__ad();
      --
  --
  
  -- Belegkopf (belkopf)
    -- UPDATE, Änderung: Typ, Belegdatum, Definitiv-Status, Abschlagsrechnungen: Abschlagsbetrag
      CREATE OR REPLACE FUNCTION tcache.clearcache_auftg_pos_wert_calc__belkopf__au() RETURNS TRIGGER AS $$
        BEGIN
          PERFORM tcache.function_cache_setdirty_1param('auftg__lief_rech_data', ag_id) FROM belkopf JOIN belzeil_grund ON bz_be_bnr = be_bnr JOIN auftg ON ag_astat = 'E' AND ag_nr = bz_auftg AND ag_pos = bz_auftgpos WHERE be_bnr = new.be_bnr;
          
          -- Die Anzahlungs-/Abschlagsrechnung bzw. Gutschrift auf Anzahlung ändert sich. Alle Schlussrechnungen an den zug. Aufträgen müssen ihren Abschlags-Wert neu kalkulieren.
          -- Rechungstyp irrelavant: Es sind alle Kombinationen (txba) möglich und Rechnung muss sich selbst zurücksetzen können.
          PERFORM tcache.function_cache_setdirty_1param('bel_abschlagrechbetrag', bz_be_bnr)
          FROM (
              SELECT DISTINCT bz_be_bnr
              FROM belzeil_grund
              WHERE bz_auftg IN (SELECT bz_auftg FROM belzeil_grund WHERE bz_be_bnr = new.be_bnr) -- Alle Schlussrechnungen anhand aller Auftragsbezüge zurücksetzen. Grund: Komplette Rechnung hat sich geändert.
              
              UNION
              SELECT new.be_bnr -- Auch Rechnung selbst setzt eigenen Abschlags-Wert zurück, wenn Belegdatum sich ändert.
          ) AS dirty_invoices;
          
          RETURN null;
        END $$ LANGUAGE plpgsql;
      
      DROP TRIGGER IF EXISTS _50cache__clearcache_auftg_pos_wert_calc__belkopf__au ON belkopf;
      
      CREATE TRIGGER _50cache__clearcache_auftg_pos_wert_calc__belkopf__au
        AFTER UPDATE
        OF be_prof, be_bdat, be_def, be_abprozent, be_gesamt_net, be_gesamt_net_basis_w, be_gesamt_steu, be_gesamt_steu_basis_w
        ON belkopf
        FOR EACH ROW
        EXECUTE PROCEDURE tcache.clearcache_auftg_pos_wert_calc__belkopf__au();
      --
  --
--

-- Adressen (adk)
  -- UPDATE
    CREATE OR REPLACE FUNCTION tcache.clearcache_adressebez__adk__au() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('adressebez', new.ad_krz);
        PERFORM tcache.function_cache_setdirty_1param('adressename', new.ad_krz);
        PERFORM tcache.function_cache_setdirty_1param('nameAufloesen', new.ad_krz);
        PERFORM tcache.function_cache_setdirty_1param('nameAufloesen', ll_minr)
            FROM llv WHERE ll_ad_krz=new.ad_krz AND ll_minr IS NOT NULL;
        PERFORM tcache.function_cache_setdirty_1param('nameAufloesen', ll_db_usename)
            FROM llv WHERE ll_ad_krz=new.ad_krz AND ll_db_usename IS NOT NULL; 
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS z50cache__clearcache_adressebez__adk__au ON adk;
    
    CREATE TRIGGER _50cache__clearcache_adressebez__adk__au
      AFTER UPDATE
      OF ad_fa1, ad_fa2, ad_name, ad_vorn, ad_str, ad_plz, ad_ort
      ON adk
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_adressebez__adk__au();
    --
  -- DELETE
    CREATE OR REPLACE FUNCTION tcache.clearcache_adressebez__adk__ad() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('adressebez', old.ad_krz);
        PERFORM tcache.function_cache_setdirty_1param('adressename', old.ad_krz);
        PERFORM tcache.function_cache_setdirty_1param('nameAufloesen', old.ad_krz);
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_adressebez__adk__ad ON adk;
    
    CREATE TRIGGER _50cache__clearcache_adressebez__adk__ad
      AFTER DELETE
      ON adk
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_adressebez__adk__ad();
    --
--

-- Tabelle adk_adresses
  -- UPDATE
    CREATE OR REPLACE FUNCTION tcache.clearcache_adressebez__adk_adresses__au() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('adressebez', new.ada_krzl);
        PERFORM tcache.function_cache_setdirty_1param('adressename', new.ada_krzl);
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
    DROP TRIGGER IF EXISTS _50cache__clearcache_adressebez__adk_adresses__au ON adk_adresses;
    
    CREATE TRIGGER _50cache__clearcache_adressebez__adk_adresses__au
      AFTER UPDATE
      OF ada_fa1, ada_name, ada_vorn, ada_str, ada_plz, ada_ort
      ON adk_adresses
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_adressebez__adk_adresses__au();
    --
  -- DELETE
    CREATE OR REPLACE FUNCTION tcache.clearcache_adressebez__adk_adresses__ad() RETURNS TRIGGER AS $$
      BEGIN
        PERFORM tcache.function_cache_setdirty_1param('adressebez', old.ada_krzl);
        PERFORM tcache.function_cache_setdirty_1param('adressename', old.ada_krzl);
        RETURN null;
      END $$ LANGUAGE plpgsql;
    
      
    DROP TRIGGER IF EXISTS z50cache__clearcache_adressebez__adk_adresses__ad ON adk_adresses;
    DROP TRIGGER IF EXISTS _50cache__clearcache_adressebez__adk_adresses__ad ON adk_adresses;
    
    CREATE TRIGGER _50cache__clearcache_adressebez__adk_adresses__ad
      AFTER DELETE
      ON adk_adresses
      FOR EACH ROW
      EXECUTE PROCEDURE tcache.clearcache_adressebez__adk_adresses__ad();
    --
--
